/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.resultset;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.loader.ResultLoaderMap;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.executor.result.DefaultResultHandler;
import org.apache.ibatis.executor.resultset.FastResultSetHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedResultSetHandler
extends FastResultSetHandler {
    private final Map<CacheKey, Object> objectCache = new HashMap<CacheKey, Object>();
    private final Map<CacheKey, Object> ancestorCache = new HashMap<CacheKey, Object>();

    public NestedResultSetHandler(Executor executor, MappedStatement mappedStatement, ParameterHandler parameterHandler, ResultHandler resultHandler, BoundSql boundSql, RowBounds rowBounds) {
        super(executor, mappedStatement, parameterHandler, resultHandler, boundSql, rowBounds);
        if (this.configuration.isSafeRowBoundsEnabled()) {
            this.ensureNoRowBounds(rowBounds);
        }
    }

    private void ensureNoRowBounds(RowBounds rowBounds) {
        if (rowBounds != null && (rowBounds.getLimit() < Integer.MAX_VALUE || rowBounds.getOffset() > 0)) {
            throw new ExecutorException("Mapped Statements with nested result mappings cannot be safely constrained by RowBounds. Use safeRowBoundsEnabled=false setting to bypass this check.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleResultSet(ResultSet rs, ResultMap resultMap, List<Object> multipleResults, FastResultSetHandler.ResultColumnCache resultColumnCache) throws SQLException {
        try {
            if (this.resultHandler == null) {
                DefaultResultHandler defaultResultHandler = new DefaultResultHandler(this.objectFactory);
                this.handleRowValues(rs, resultMap, defaultResultHandler, this.rowBounds, resultColumnCache);
                multipleResults.add(defaultResultHandler.getResultList());
            } else {
                if (this.configuration.isSafeResultHandlerEnabled()) {
                    throw new ExecutorException("Mapped Statements with nested result mappings cannot be safely used with a custom ResultHandler. Use safeResultHandlerEnabled=false setting to bypass this check.");
                }
                this.handleRowValues(rs, resultMap, this.resultHandler, this.rowBounds, resultColumnCache);
            }
        }
        finally {
            this.closeResultSet(rs);
        }
    }

    @Override
    protected void cleanUpAfterHandlingResultSet() {
        super.cleanUpAfterHandlingResultSet();
        this.objectCache.clear();
    }

    @Override
    protected void handleRowValues(ResultSet rs, ResultMap resultMap, ResultHandler resultHandler, RowBounds rowBounds, FastResultSetHandler.ResultColumnCache resultColumnCache) throws SQLException {
        DefaultResultContext resultContext = new DefaultResultContext();
        this.skipRows(rs, rowBounds);
        while (this.shouldProcessMoreRows(rs, resultContext, rowBounds)) {
            ResultMap discriminatedResultMap = this.resolveDiscriminatedResultMap(rs, resultMap, null);
            CacheKey rowKey = this.createRowKey(discriminatedResultMap, rs, null, resultColumnCache);
            boolean knownValue = this.objectCache.containsKey(rowKey);
            Object rowValue = this.getRowValue(rs, discriminatedResultMap, rowKey, resultColumnCache);
            if (knownValue) continue;
            resultContext.nextResultObject(rowValue);
            resultHandler.handleResult(resultContext);
        }
    }

    @Override
    protected Object getRowValue(ResultSet rs, ResultMap resultMap, CacheKey rowKey, FastResultSetHandler.ResultColumnCache resultColumnCache) throws SQLException {
        return this.getRowValue(rs, resultMap, rowKey, rowKey, null, resultColumnCache);
    }

    protected Object getRowValue(ResultSet rs, ResultMap resultMap, CacheKey combinedKey, CacheKey rowKey, String columnPrefix, FastResultSetHandler.ResultColumnCache resultColumnCache) throws SQLException {
        if (this.ancestorCache.containsKey(rowKey)) {
            return this.ancestorCache.get(rowKey);
        }
        if (this.objectCache.containsKey(combinedKey)) {
            Object resultObject = this.objectCache.get(combinedKey);
            if (rowKey != CacheKey.NULL_CACHE_KEY) {
                this.ancestorCache.put(rowKey, resultObject);
            }
            MetaObject metaObject = this.configuration.newMetaObject(resultObject);
            this.applyNestedResultMappings(rs, resultMap, metaObject, columnPrefix, resultColumnCache, combinedKey);
            this.ancestorCache.remove(rowKey);
            return resultObject;
        }
        ResultLoaderMap lazyLoader = this.instantiateResultLoaderMap();
        Object resultObject = this.createResultObject(rs, resultMap, lazyLoader, columnPrefix, resultColumnCache);
        if (resultObject != null && !this.typeHandlerRegistry.hasTypeHandler(resultMap.getType())) {
            List<String> mappedColumnNames;
            boolean foundValues;
            if (rowKey != CacheKey.NULL_CACHE_KEY) {
                this.ancestorCache.put(rowKey, resultObject);
            }
            MetaObject metaObject = this.configuration.newMetaObject(resultObject);
            boolean bl = foundValues = resultMap.getConstructorResultMappings().size() > 0;
            if (AutoMappingBehavior.FULL.equals((Object)this.configuration.getAutoMappingBehavior())) {
                List<String> unmappedColumnNames = resultColumnCache.getUnmappedColumnNames(resultMap, columnPrefix);
                foundValues = this.applyAutomaticMappings(rs, unmappedColumnNames, metaObject, columnPrefix, resultColumnCache) || foundValues;
            }
            foundValues = this.applyPropertyMappings(rs, resultMap, mappedColumnNames = resultColumnCache.getMappedColumnNames(resultMap, columnPrefix), metaObject, lazyLoader, columnPrefix) || foundValues;
            foundValues = this.applyNestedResultMappings(rs, resultMap, metaObject, columnPrefix, resultColumnCache, combinedKey) || foundValues;
            foundValues = lazyLoader != null && lazyLoader.size() > 0 || foundValues;
            resultObject = foundValues ? resultObject : null;
            this.ancestorCache.remove(rowKey);
        }
        if (combinedKey != CacheKey.NULL_CACHE_KEY) {
            this.objectCache.put(combinedKey, resultObject);
        }
        return resultObject;
    }

    private boolean applyNestedResultMappings(ResultSet rs, ResultMap resultMap, MetaObject metaObject, String parentPrefix, FastResultSetHandler.ResultColumnCache resultColumnCache, CacheKey parentRowKey) {
        boolean foundValues = false;
        for (ResultMapping resultMapping : resultMap.getPropertyResultMappings()) {
            String nestedResultMapId = resultMapping.getNestedResultMapId();
            if (nestedResultMapId == null) continue;
            try {
                StringBuilder columnPrefixBuilder = new StringBuilder();
                if (parentPrefix != null) {
                    columnPrefixBuilder.append(parentPrefix);
                }
                if (resultMapping.getColumnPrefix() != null) {
                    columnPrefixBuilder.append(resultMapping.getColumnPrefix());
                }
                String columnPrefix = columnPrefixBuilder.length() == 0 ? null : columnPrefixBuilder.toString().toUpperCase(Locale.ENGLISH);
                ResultMap nestedResultMap = this.getNestedResultMap(rs, nestedResultMapId, columnPrefix);
                Object targetProperty = this.instantiateCollectionPropertyIfAppropriate(resultMapping, metaObject);
                MetaObject targetMetaObject = this.configuration.newMetaObject(targetProperty);
                CacheKey rowKey = this.createRowKey(nestedResultMap, rs, columnPrefix, resultColumnCache);
                CacheKey combinedKey = this.getCombinedKey(rowKey, parentRowKey);
                boolean knownValue = this.objectCache.containsKey(combinedKey);
                Object rowValue = this.getRowValue(rs, nestedResultMap, combinedKey, rowKey, columnPrefix, resultColumnCache);
                if (rowValue == null || !this.anyNotNullColumnHasValue(resultMapping, columnPrefix, rs)) continue;
                if (targetProperty != null && this.objectFactory.isCollection(targetProperty.getClass())) {
                    if (!knownValue) {
                        targetMetaObject.add(rowValue);
                    }
                } else {
                    metaObject.setValue(resultMapping.getProperty(), rowValue);
                }
                foundValues = true;
            }
            catch (Exception e) {
                throw new ExecutorException("Error getting nested result map values for '" + resultMapping.getProperty() + "'.  Cause: " + e, e);
            }
        }
        return foundValues;
    }

    private boolean anyNotNullColumnHasValue(ResultMapping resultMapping, String columnPrefix, ResultSet rs) throws SQLException {
        Set<String> notNullColumns = resultMapping.getNotNullColumns();
        boolean anyNotNullColumnIsNotNull = true;
        if (notNullColumns != null && !notNullColumns.isEmpty()) {
            anyNotNullColumnIsNotNull = false;
            for (String column : notNullColumns) {
                rs.getObject(NestedResultSetHandler.prependPrefix(column, columnPrefix));
                if (rs.wasNull()) continue;
                anyNotNullColumnIsNotNull = true;
                break;
            }
        }
        return anyNotNullColumnIsNotNull;
    }

    private Object instantiateCollectionPropertyIfAppropriate(ResultMapping resultMapping, MetaObject metaObject) {
        String propertyName = resultMapping.getProperty();
        Class<?> type = resultMapping.getJavaType();
        Object propertyValue = metaObject.getValue(propertyName);
        if (propertyValue == null) {
            if (type == null) {
                type = metaObject.getSetterType(propertyName);
            }
            try {
                if (this.objectFactory.isCollection(type)) {
                    propertyValue = this.objectFactory.create(type);
                    metaObject.setValue(propertyName, propertyValue);
                }
            }
            catch (Exception e) {
                throw new ExecutorException("Error instantiating collection property for result '" + resultMapping.getProperty() + "'.  Cause: " + e, e);
            }
        }
        return propertyValue;
    }

    private ResultMap getNestedResultMap(ResultSet rs, String nestedResultMapId, String columnPrefix) throws SQLException {
        ResultMap nestedResultMap = this.configuration.getResultMap(nestedResultMapId);
        nestedResultMap = this.resolveDiscriminatedResultMap(rs, nestedResultMap, columnPrefix);
        return nestedResultMap;
    }

    private CacheKey createRowKey(ResultMap resultMap, ResultSet rs, String columnPrefix, FastResultSetHandler.ResultColumnCache resultColumnCache) throws SQLException {
        CacheKey cacheKey = new CacheKey();
        cacheKey.update(resultMap.getId());
        List<ResultMapping> resultMappings = this.getResultMappingsForRowKey(resultMap);
        if (resultMappings.size() == 0) {
            if (Map.class.isAssignableFrom(resultMap.getType())) {
                this.createRowKeyForMap(rs, cacheKey);
            } else {
                this.createRowKeyForUnmappedProperties(resultMap, rs, cacheKey, columnPrefix, resultColumnCache);
            }
        } else {
            this.createRowKeyForMappedProperties(rs, cacheKey, resultMappings, columnPrefix);
        }
        if (cacheKey.getUpdateCount() < 2) {
            return CacheKey.NULL_CACHE_KEY;
        }
        return cacheKey;
    }

    private CacheKey getCombinedKey(CacheKey rowKey, CacheKey parentRowKey) throws CloneNotSupportedException {
        if (rowKey != CacheKey.NULL_CACHE_KEY && parentRowKey != CacheKey.NULL_CACHE_KEY) {
            CacheKey combinedKey = rowKey.clone();
            combinedKey.update(parentRowKey);
            return combinedKey;
        }
        return CacheKey.NULL_CACHE_KEY;
    }

    private List<ResultMapping> getResultMappingsForRowKey(ResultMap resultMap) {
        List<ResultMapping> resultMappings = resultMap.getIdResultMappings();
        if (resultMappings.size() == 0) {
            resultMappings = resultMap.getPropertyResultMappings();
        }
        return resultMappings;
    }

    private void createRowKeyForMappedProperties(ResultSet rs, CacheKey cacheKey, List<ResultMapping> resultMappings, String columnPrefix) throws SQLException {
        for (ResultMapping resultMapping : resultMappings) {
            Object value;
            if (resultMapping.getNestedResultMapId() != null) {
                ResultMap myResultMap = this.configuration.getResultMap(resultMapping.getNestedResultMapId());
                this.createRowKeyForMappedProperties(rs, cacheKey, myResultMap.getConstructorResultMappings(), NestedResultSetHandler.prependPrefix(resultMapping.getColumnPrefix(), columnPrefix));
                continue;
            }
            if (resultMapping.getNestedQueryId() != null) continue;
            String column = NestedResultSetHandler.prependPrefix(resultMapping.getColumn(), columnPrefix);
            TypeHandler<?> th = resultMapping.getTypeHandler();
            if (column == null || !this.resultSetHasColumn(rs, column) || (value = th.getResult(rs, column)) == null) continue;
            cacheKey.update(column);
            cacheKey.update(value);
        }
    }

    private void createRowKeyForUnmappedProperties(ResultMap resultMap, ResultSet rs, CacheKey cacheKey, String columnPrefix, FastResultSetHandler.ResultColumnCache resultColumnCache) throws SQLException {
        MetaClass metaType = MetaClass.forClass(resultMap.getType());
        List<String> unmappedColumnNames = resultColumnCache.getUnmappedColumnNames(resultMap, columnPrefix);
        Iterator<String> i$ = unmappedColumnNames.iterator();
        while (i$.hasNext()) {
            String value;
            String column;
            String property = column = i$.next();
            if (columnPrefix != null && columnPrefix.length() > 0) {
                if (!column.startsWith(columnPrefix)) continue;
                property = column.substring(columnPrefix.length());
            }
            if (metaType.findProperty(property) == null || (value = rs.getString(column)) == null) continue;
            cacheKey.update(column);
            cacheKey.update(value);
        }
    }

    private void createRowKeyForMap(ResultSet rs, CacheKey cacheKey) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = this.configuration.isUseColumnLabel() ? rsmd.getColumnLabel(i) : rsmd.getColumnName(i);
            String value = rs.getString(columnName);
            if (value == null) continue;
            cacheKey.update(columnName);
            cacheKey.update(value);
        }
    }

    protected boolean resultSetHasColumn(ResultSet rs, String column) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String label = rsmd.getColumnLabel(i);
                if (!column.equalsIgnoreCase(label)) continue;
                return true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }
}

