/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerMethod {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Object bean;
    private final Method method;
    private final BeanFactory beanFactory;
    private MethodParameter[] parameters;
    private final Method bridgedMethod;

    public HandlerMethod(Object bean, Method method) {
        Assert.notNull((Object)bean, (String)"bean must not be null");
        Assert.notNull((Object)method, (String)"method must not be null");
        this.bean = bean;
        this.beanFactory = null;
        this.method = method;
        this.bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
    }

    public HandlerMethod(Object bean, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Assert.notNull((Object)bean, (String)"bean must not be null");
        Assert.notNull((Object)methodName, (String)"method must not be null");
        this.bean = bean;
        this.beanFactory = null;
        this.method = bean.getClass().getMethod(methodName, parameterTypes);
        this.bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)this.method);
    }

    public HandlerMethod(String beanName, BeanFactory beanFactory, Method method) {
        Assert.hasText((String)beanName, (String)"'beanName' must not be null");
        Assert.notNull((Object)beanFactory, (String)"'beanFactory' must not be null");
        Assert.notNull((Object)method, (String)"'method' must not be null");
        Assert.isTrue((boolean)beanFactory.containsBean(beanName), (String)("Bean factory [" + beanFactory + "] does not contain bean " + "with name [" + beanName + "]"));
        this.bean = beanName;
        this.beanFactory = beanFactory;
        this.method = method;
        this.bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
    }

    public Object getBean() {
        return this.bean;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getBeanType() {
        if (this.bean instanceof String) {
            String beanName = (String)this.bean;
            return this.beanFactory.getType(beanName);
        }
        return ClassUtils.getUserClass(this.bean.getClass());
    }

    protected Method getBridgedMethod() {
        return this.bridgedMethod;
    }

    public MethodParameter[] getMethodParameters() {
        if (this.parameters == null) {
            int parameterCount = this.bridgedMethod.getParameterTypes().length;
            MethodParameter[] p = new MethodParameter[parameterCount];
            int i = 0;
            while (i < parameterCount) {
                p[i] = new HandlerMethodParameter(this.bridgedMethod, i);
                ++i;
            }
            this.parameters = p;
        }
        return this.parameters;
    }

    public MethodParameter getReturnType() {
        return new HandlerMethodParameter(this.bridgedMethod, -1);
    }

    public boolean isVoid() {
        return Void.TYPE.equals(this.getReturnType().getParameterType());
    }

    public <A extends Annotation> A getMethodAnnotation(Class<A> annotationType) {
        return (A)AnnotationUtils.findAnnotation((Method)this.method, annotationType);
    }

    public HandlerMethod createWithResolvedBean() {
        Object handler = this.bean;
        if (this.bean instanceof String) {
            String beanName = (String)this.bean;
            handler = this.beanFactory.getBean(beanName);
        }
        return new HandlerMethod(handler, this.method);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o instanceof HandlerMethod) {
            HandlerMethod other = (HandlerMethod)o;
            return this.bean.equals(other.bean) && this.method.equals(other.method);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.bean.hashCode() + this.method.hashCode();
    }

    public String toString() {
        return this.method.toGenericString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HandlerMethodParameter
    extends MethodParameter {
        public HandlerMethodParameter(Method method, int parameterIndex) {
            super(method, parameterIndex);
        }

        public Class<?> getDeclaringClass() {
            return HandlerMethod.this.getBeanType();
        }

        public <T extends Annotation> T getMethodAnnotation(Class<T> annotationType) {
            return HandlerMethod.this.getMethodAnnotation(annotationType);
        }
    }
}

