/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.mapping;

import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterMapping {
    private Configuration configuration;
    private String property;
    private ParameterMode mode;
    private Class<?> javaType = Object.class;
    private JdbcType jdbcType;
    private Integer numericScale;
    private TypeHandler<?> typeHandler;
    private String resultMapId;
    private String jdbcTypeName;

    private ParameterMapping() {
    }

    public String getProperty() {
        return this.property;
    }

    public ParameterMode getMode() {
        return this.mode;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public Integer getNumericScale() {
        return this.numericScale;
    }

    public TypeHandler<?> getTypeHandler() {
        return this.typeHandler;
    }

    public String getResultMapId() {
        return this.resultMapId;
    }

    public String getJdbcTypeName() {
        return this.jdbcTypeName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private ParameterMapping parameterMapping = new ParameterMapping();

        public Builder(Configuration configuration, String property, TypeHandler<?> typeHandler) {
            this.parameterMapping.configuration = configuration;
            this.parameterMapping.property = property;
            this.parameterMapping.typeHandler = typeHandler;
            this.parameterMapping.mode = ParameterMode.IN;
        }

        public Builder(Configuration configuration, String property, Class<?> javaType) {
            this.parameterMapping.configuration = configuration;
            this.parameterMapping.property = property;
            this.parameterMapping.javaType = javaType;
            this.parameterMapping.mode = ParameterMode.IN;
        }

        public Builder mode(ParameterMode mode) {
            this.parameterMapping.mode = mode;
            return this;
        }

        public Builder javaType(Class<?> javaType) {
            this.parameterMapping.javaType = javaType;
            return this;
        }

        public Builder jdbcType(JdbcType jdbcType) {
            this.parameterMapping.jdbcType = jdbcType;
            return this;
        }

        public Builder numericScale(Integer numericScale) {
            this.parameterMapping.numericScale = numericScale;
            return this;
        }

        public Builder resultMapId(String resultMapId) {
            this.parameterMapping.resultMapId = resultMapId;
            return this;
        }

        public Builder typeHandler(TypeHandler<?> typeHandler) {
            this.parameterMapping.typeHandler = typeHandler;
            return this;
        }

        public Builder jdbcTypeName(String jdbcTypeName) {
            this.parameterMapping.jdbcTypeName = jdbcTypeName;
            return this;
        }

        public ParameterMapping build() {
            this.resolveTypeHandler();
            return this.parameterMapping;
        }

        private void resolveTypeHandler() {
            if (this.parameterMapping.typeHandler == null && this.parameterMapping.javaType != null) {
                Configuration configuration = this.parameterMapping.configuration;
                TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
                this.parameterMapping.typeHandler = typeHandlerRegistry.getTypeHandler(this.parameterMapping.javaType, this.parameterMapping.jdbcType);
            }
        }
    }
}

