/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.mapping;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.DatabaseIdProvider;

public class DefaultDatabaseIdProvider
implements DatabaseIdProvider {
    private Properties properties;

    public String getDatabaseId(DataSource dataSource) {
        try {
            return this.getDatabaseName(dataSource);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setProperties(Properties p) {
        this.properties = p;
    }

    private String getDatabaseName(DataSource dataSource) throws SQLException {
        String productName = this.getDatabaseProductName(dataSource);
        if (this.properties != null) {
            return this.properties.getProperty(productName);
        }
        return productName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatabaseProductName(DataSource dataSource) throws SQLException {
        Connection con = null;
        try {
            con = dataSource.getConnection();
            DatabaseMetaData metaData = con.getMetaData();
            String string = metaData.getDatabaseProductName();
            return string;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }
}

