/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.xml.dynamic;

import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.xml.dynamic.DynamicContext;
import org.apache.ibatis.builder.xml.dynamic.OgnlCache;
import org.apache.ibatis.builder.xml.dynamic.SqlNode;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.apache.ibatis.type.SimpleTypeRegistry;

public class TextSqlNode
implements SqlNode {
    private String text;

    public TextSqlNode(String text) {
        this.text = text;
    }

    public boolean apply(DynamicContext context) {
        GenericTokenParser parser = new GenericTokenParser("${", "}", new BindingTokenParser(context));
        context.appendSql(parser.parse(this.text));
        return true;
    }

    private static class BindingTokenParser
    implements TokenHandler {
        private DynamicContext context;

        public BindingTokenParser(DynamicContext context) {
            this.context = context;
        }

        public String handleToken(String content) {
            try {
                Object parameter = this.context.getBindings().get("_parameter");
                if (parameter == null) {
                    this.context.getBindings().put("value", null);
                } else if (SimpleTypeRegistry.isSimpleType(parameter.getClass())) {
                    this.context.getBindings().put("value", parameter);
                }
                Object value = OgnlCache.getValue(content, this.context.getBindings());
                return value == null ? "" : String.valueOf(value);
            }
            catch (OgnlException e) {
                throw new BuilderException("Error evaluating expression '" + content + "'. Cause: " + e, e);
            }
        }
    }
}

