/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.client.j2se.Config;
import com.google.zxing.client.j2se.DecodeWorker;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;

public final class CommandLineRunner {
    private static final String POSSIBLE_FORMATS_ARG = "--possibleFormats=";
    private static final Pattern COMMA = Pattern.compile(",");

    private CommandLineRunner() {
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Exception {
        Object[] crop;
        if (args.length == 0) {
            CommandLineRunner.printUsage();
            return;
        }
        Config config = new Config();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if ("--try_harder".equals(arg)) {
                config.setTryHarder(true);
            } else if ("--pure_barcode".equals(arg)) {
                config.setPureBarcode(true);
            } else if ("--products_only".equals(arg)) {
                config.setProductsOnly(true);
            } else if ("--dump_results".equals(arg)) {
                config.setDumpResults(true);
            } else if ("--dump_black_point".equals(arg)) {
                config.setDumpBlackPoint(true);
            } else if ("--multi".equals(arg)) {
                config.setMulti(true);
            } else if ("--brief".equals(arg)) {
                config.setBrief(true);
            } else if ("--recursive".equals(arg)) {
                config.setRecursive(true);
            } else if (arg.startsWith("--crop")) {
                crop = new int[4];
                String[] stringArray2 = COMMA.split(arg.substring(7));
                int i = 0;
                while (i < crop.length) {
                    crop[i] = (String)Integer.parseInt(stringArray2[i]);
                    ++i;
                }
                config.setCrop((int[])crop);
            } else if (arg.startsWith(POSSIBLE_FORMATS_ARG)) {
                config.setPossibleFormats(COMMA.split(arg.substring(POSSIBLE_FORMATS_ARG.length())));
            } else if (arg.startsWith("-")) {
                System.err.println("Unknown command line option " + arg);
                CommandLineRunner.printUsage();
                return;
            }
            ++n2;
        }
        config.setHints(CommandLineRunner.buildHints(config));
        ConcurrentLinkedQueue<String> inputs = new ConcurrentLinkedQueue<String>();
        crop = args;
        int n3 = args.length;
        n = 0;
        while (n < n3) {
            String arg = crop[n];
            if (!arg.startsWith("--")) {
                CommandLineRunner.addArgumentToInputs(arg, config, inputs);
            }
            ++n;
        }
        int numThreads = Math.min(inputs.size(), Runtime.getRuntime().availableProcessors());
        int successful = 0;
        if (numThreads > 1) {
            void var7_14;
            ExecutorService executor = Executors.newFixedThreadPool(numThreads);
            ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>(numThreads);
            boolean bl = false;
            while (var7_14 < numThreads) {
                futures.add(executor.submit(new DecodeWorker(config, inputs)));
                ++var7_14;
            }
            executor.shutdown();
            for (Future future : futures) {
                successful += ((Integer)future.get()).intValue();
            }
        } else {
            successful += new DecodeWorker(config, inputs).call().intValue();
        }
        int total = inputs.size();
        if (total > 1) {
            System.out.println("\nDecoded " + successful + " files out of " + total + " successfully (" + successful * 100 / total + "%)\n");
        }
    }

    private static void addArgumentToInputs(String argument, Config config, Queue<String> inputs) throws IOException {
        File inputFile = new File(argument);
        if (inputFile.exists()) {
            if (inputFile.isDirectory()) {
                File[] fileArray = inputFile.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File singleFile = fileArray[n2];
                    String filename = singleFile.getName().toLowerCase(Locale.ENGLISH);
                    if (!filename.startsWith(".")) {
                        if (singleFile.isDirectory()) {
                            if (config.isRecursive()) {
                                CommandLineRunner.addArgumentToInputs(singleFile.getAbsolutePath(), config, inputs);
                            }
                        } else if (!filename.endsWith(".txt") && !filename.contains(".mono.png")) {
                            inputs.add(singleFile.getCanonicalPath());
                        }
                    }
                    ++n2;
                }
            } else {
                inputs.add(inputFile.getCanonicalPath());
            }
        } else {
            inputs.add(argument);
        }
    }

    private static Map<DecodeHintType, ?> buildHints(Config config) {
        ArrayList<BarcodeFormat> possibleFormats = new ArrayList<BarcodeFormat>();
        String[] possibleFormatsNames = config.getPossibleFormats();
        if (possibleFormatsNames != null && possibleFormatsNames.length > 0) {
            String[] stringArray = possibleFormatsNames;
            int n = possibleFormatsNames.length;
            int n2 = 0;
            while (n2 < n) {
                String format = stringArray[n2];
                possibleFormats.add(BarcodeFormat.valueOf((String)format));
                ++n2;
            }
        } else {
            possibleFormats.add(BarcodeFormat.UPC_A);
            possibleFormats.add(BarcodeFormat.UPC_E);
            possibleFormats.add(BarcodeFormat.EAN_13);
            possibleFormats.add(BarcodeFormat.EAN_8);
            possibleFormats.add(BarcodeFormat.RSS_14);
            possibleFormats.add(BarcodeFormat.RSS_EXPANDED);
            if (!config.isProductsOnly()) {
                possibleFormats.add(BarcodeFormat.CODE_39);
                possibleFormats.add(BarcodeFormat.CODE_93);
                possibleFormats.add(BarcodeFormat.CODE_128);
                possibleFormats.add(BarcodeFormat.ITF);
                possibleFormats.add(BarcodeFormat.QR_CODE);
                possibleFormats.add(BarcodeFormat.DATA_MATRIX);
                possibleFormats.add(BarcodeFormat.AZTEC);
                possibleFormats.add(BarcodeFormat.PDF_417);
                possibleFormats.add(BarcodeFormat.CODABAR);
                possibleFormats.add(BarcodeFormat.MAXICODE);
            }
        }
        EnumMap<DecodeHintType, Serializable> hints = new EnumMap<DecodeHintType, Serializable>(DecodeHintType.class);
        hints.put(DecodeHintType.POSSIBLE_FORMATS, possibleFormats);
        if (config.isTryHarder()) {
            hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        }
        if (config.isPureBarcode()) {
            hints.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
        }
        return hints;
    }

    private static void printUsage() {
        System.err.println("Decode barcode images using the ZXing library");
        System.err.println();
        System.err.println("usage: CommandLineRunner { file | dir | url } [ options ]");
        System.err.println("  --try_harder: Use the TRY_HARDER hint, default is normal (mobile) mode");
        System.err.println("  --pure_barcode: Input image is a pure monochrome barcode image, not a photo");
        System.err.println("  --products_only: Only decode the UPC and EAN families of barcodes");
        System.err.println("  --dump_results: Write the decoded contents to input.txt");
        System.err.println("  --dump_black_point: Compare black point algorithms as input.mono.png");
        System.err.println("  --multi: Scans image for multiple barcodes");
        System.err.println("  --brief: Only output one line per file, omitting the contents");
        System.err.println("  --recursive: Descend into subdirectories");
        System.err.println("  --crop=left,top,width,height: Only examine cropped region of input image(s)");
        StringBuilder builder = new StringBuilder("  --possibleFormats=barcodeFormat[,barcodeFormat2...] where barcodeFormat is any of: ");
        BarcodeFormat[] barcodeFormatArray = BarcodeFormat.values();
        int n = barcodeFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            BarcodeFormat format = barcodeFormatArray[n2];
            builder.append(format).append(',');
            ++n2;
        }
        builder.setLength(builder.length() - 1);
        System.err.println(builder);
    }
}

