/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import snaq.db.DBPoolDataSource;

public class DBPoolDataSourceFactory
implements ObjectFactory {
    protected static final Log logger = LogFactory.getLog(DBPoolDataSourceFactory.class);

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Object : " + obj));
            logger.debug((Object)("Name   : " + name + " (" + name.getClass().getName() + ")"));
            logger.debug((Object)("Context: " + nameCtx));
            ArrayList list = new ArrayList(environment.keySet());
            Collections.sort(list);
            for (Object o : list) {
                logger.debug((Object)("Environment[" + o + "]: " + environment.get(o)));
            }
        }
        if (!(obj instanceof Reference)) {
            return null;
        }
        DBPoolDataSource ds = new DBPoolDataSource();
        ds.registerShutdownHook();
        Reference ref = (Reference)obj;
        Enumeration<RefAddr> e = ref.getAll();
        while (e.hasMoreElements()) {
            RefAddr addr = e.nextElement();
            String refName = addr.getType();
            String refValue = (String)addr.getContent();
            if (refName.equalsIgnoreCase("description")) {
                ds.setDriverClassName(refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("user") || refName.equalsIgnoreCase("username")) {
                ds.setUser(refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("password")) {
                ds.setPassword(refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("driverClassName")) {
                ds.setDriverClassName(refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("url")) {
                ds.setUrl(refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("passwordDecoderClassName")) {
                ds.setPasswordDecoderClassName(refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("validatorClassName")) {
                ds.setValidatorClassName(refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("validationQuery")) {
                ds.setValidationQuery(refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("minPool")) {
                try {
                    ds.setMinPool(Integer.parseInt(refValue));
                    continue;
                }
                catch (NumberFormatException nfx) {
                    throw new NamingException("Invalid '" + refName + "' value: " + refValue);
                }
            }
            if (refName.equalsIgnoreCase("maxPool") || refName.equalsIgnoreCase("poolSize")) {
                if (refName.equalsIgnoreCase("poolSize")) {
                    logger.warn((Object)"Attribute 'poolSize' is deprecated; use 'maxPool' instead");
                }
                try {
                    ds.setMaxPool(Integer.parseInt(refValue));
                    continue;
                }
                catch (NumberFormatException nfx) {
                    throw new NamingException("Invalid '" + refName + "' value: " + refValue);
                }
            }
            if (refName.equalsIgnoreCase("maxSize") || refName.equalsIgnoreCase("maxConn")) {
                if (refName.equalsIgnoreCase("maxConn")) {
                    logger.warn((Object)"Attribute 'maxConn' is deprecated; use 'maxSize' instead");
                }
                try {
                    ds.setMaxSize(Integer.parseInt(refValue));
                    continue;
                }
                catch (NumberFormatException nfx) {
                    throw new NamingException("Invalid '" + refName + "' value: " + refValue);
                }
            }
            if (refName.equalsIgnoreCase("idleTimeout") || refName.equalsIgnoreCase("expiryTime")) {
                if (refName.equalsIgnoreCase("expiryTime")) {
                    logger.warn((Object)"Attribute 'expiryTime' is deprecated; use 'idleTimeout' instead");
                }
                try {
                    ds.setIdleTimeout(Integer.parseInt(refValue));
                    continue;
                }
                catch (NumberFormatException nfx) {
                    throw new NamingException("Invalid '" + refName + "' value: " + refValue);
                }
            }
            if (refName.equalsIgnoreCase("loginTimeout")) {
                try {
                    ds.setLoginTimeout(Integer.parseInt(refValue));
                    continue;
                }
                catch (NumberFormatException nfx) {
                    throw new NamingException("Invalid '" + refName + "' value: " + refValue);
                }
            }
            logger.info((Object)("Unknown reference '" + refName + "' with value: " + refValue));
        }
        return ds;
    }
}

