/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.File;
import java.io.IOException;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public abstract class FileSystemUtils {
    public static boolean deleteRecursively(File root) {
        if (root != null && root.exists()) {
            File[] children;
            if (root.isDirectory() && (children = root.listFiles()) != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    FileSystemUtils.deleteRecursively(child);
                    ++n2;
                }
            }
            return root.delete();
        }
        return false;
    }

    public static void copyRecursively(File src, File dest) throws IOException {
        Assert.isTrue(src != null && (src.isDirectory() || src.isFile()), "Source File must denote a directory or file");
        Assert.notNull(dest, "Destination File must not be null");
        FileSystemUtils.doCopyRecursively(src, dest);
    }

    private static void doCopyRecursively(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            dest.mkdir();
            File[] entries = src.listFiles();
            if (entries == null) {
                throw new IOException("Could not list files in directory: " + src);
            }
            File[] fileArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                File entry = fileArray[n2];
                FileSystemUtils.doCopyRecursively(entry, new File(dest, entry.getName()));
                ++n2;
            }
        } else if (src.isFile()) {
            try {
                dest.createNewFile();
            }
            catch (IOException ex) {
                IOException ioex = new IOException("Failed to create file: " + dest);
                ioex.initCause(ex);
                throw ioex;
            }
            FileCopyUtils.copy(src, dest);
        }
    }
}

