/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.statement;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.CallableStatementHandler;
import org.apache.ibatis.executor.statement.PreparedStatementHandler;
import org.apache.ibatis.executor.statement.SimpleStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutingStatementHandler
implements StatementHandler {
    private final StatementHandler delegate;

    public RoutingStatementHandler(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        switch (ms.getStatementType()) {
            case STATEMENT: {
                this.delegate = new SimpleStatementHandler(executor, ms, parameter, rowBounds, resultHandler, boundSql);
                break;
            }
            case PREPARED: {
                this.delegate = new PreparedStatementHandler(executor, ms, parameter, rowBounds, resultHandler, boundSql);
                break;
            }
            case CALLABLE: {
                this.delegate = new CallableStatementHandler(executor, ms, parameter, rowBounds, resultHandler, boundSql);
                break;
            }
            default: {
                throw new ExecutorException("Unknown statement type: " + (Object)((Object)ms.getStatementType()));
            }
        }
    }

    @Override
    public Statement prepare(Connection connection) throws SQLException {
        return this.delegate.prepare(connection);
    }

    @Override
    public void parameterize(Statement statement) throws SQLException {
        this.delegate.parameterize(statement);
    }

    @Override
    public void batch(Statement statement) throws SQLException {
        this.delegate.batch(statement);
    }

    @Override
    public int update(Statement statement) throws SQLException {
        return this.delegate.update(statement);
    }

    @Override
    public <E> List<E> query(Statement statement, ResultHandler resultHandler) throws SQLException {
        return this.delegate.query(statement, resultHandler);
    }

    @Override
    public BoundSql getBoundSql() {
        return this.delegate.getBoundSql();
    }

    @Override
    public ParameterHandler getParameterHandler() {
        return this.delegate.getParameterHandler();
    }
}

