/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.support.DefaultDataBinderFactory;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.InvocableHandlerMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitBinderDataBinderFactory
extends DefaultDataBinderFactory {
    private final List<InvocableHandlerMethod> binderMethods;

    public InitBinderDataBinderFactory(List<InvocableHandlerMethod> binderMethods, WebBindingInitializer initializer) {
        super(initializer);
        this.binderMethods = binderMethods != null ? binderMethods : new ArrayList();
    }

    @Override
    public void initBinder(WebDataBinder binder, NativeWebRequest request) throws Exception {
        for (InvocableHandlerMethod binderMethod : this.binderMethods) {
            Object returnValue;
            if (!this.isBinderMethodApplicable(binderMethod, binder) || (returnValue = binderMethod.invokeForRequest(request, null, new Object[]{binder})) == null) continue;
            throw new IllegalStateException("@InitBinder methods should return void: " + binderMethod);
        }
    }

    protected boolean isBinderMethodApplicable(HandlerMethod initBinderMethod, WebDataBinder binder) {
        InitBinder annot = initBinderMethod.getMethodAnnotation(InitBinder.class);
        Collection names = Arrays.asList(annot.value());
        return names.size() == 0 || names.contains(binder.getObjectName());
    }
}

