/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import java.io.IOException;
import java.io.Writer;

public class JSONWriter {
    private SerializeWriter writer;
    private final Writer out;
    private JSONSerializer serializer;
    private Context context;

    public JSONWriter(Writer out) {
        this.out = out;
        this.writer = new SerializeWriter();
        this.serializer = new JSONSerializer(this.writer);
    }

    public void flush() throws IOException {
        this.writer.writeTo(this.out);
        this.writer = new SerializeWriter();
        this.serializer = new JSONSerializer(this.writer);
    }

    public void close() throws IOException {
        if (this.writer.size() != 0) {
            this.flush();
        }
    }

    public void writeStartObject() {
        if (this.context == null) {
            this.context = new Context(null, State.BeginObject);
        } else {
            if (this.context.getState() == State.PropertyKey) {
                this.writer.write(':');
            } else if (this.context.getState() == State.ArrayValue) {
                this.writer.write(',');
            } else if (this.context.getState() != State.BeginObject && this.context.getState() != State.BeginArray) {
                throw new JSONException("illegal state : " + (Object)((Object)this.context.getState()));
            }
            this.context = new Context(this.context, State.BeginObject);
        }
        this.writer.write('{');
    }

    public void writeEndObject() {
        this.writer.write('}');
        this.context = this.context.getParent();
        if (this.context != null) {
            if (this.context.getState() == State.PropertyKey) {
                this.context.setState(State.PropertyValue);
            } else if (this.context.getState() == State.BeginArray) {
                this.context.setState(State.ArrayValue);
            } else if (this.context.getState() == State.ArrayValue) {
                // empty if block
            }
        }
    }

    public void writeKey(String key) {
        if (this.context.getState() == State.PropertyValue) {
            this.writer.write(',');
        }
        this.writer.writeString(key);
        this.context.setState(State.PropertyKey);
    }

    public void writeValue(Object object) {
        if (this.context.getState() == State.PropertyKey) {
            this.writer.write(':');
        }
        this.serializer.write(object);
        this.context.setState(State.PropertyValue);
    }

    public void writeStartArray() {
        if (this.context == null) {
            this.context = new Context(null, State.BeginArray);
        } else {
            if (this.context.getState() == State.PropertyKey) {
                this.writer.write(':');
            } else if (this.context.getState() == State.ArrayValue) {
                this.writer.write(',');
            } else if (this.context.getState() != State.BeginArray) {
                throw new JSONException("illegal state : " + (Object)((Object)this.context.getState()));
            }
            this.context = new Context(this.context, State.BeginArray);
        }
        this.writer.write('[');
    }

    public void writeEndArray() {
        this.writer.write(']');
        this.context = this.context.getParent();
        if (this.context != null) {
            if (this.context.getState() == State.PropertyKey) {
                this.context.setState(State.PropertyValue);
            } else if (this.context.getState() == State.BeginArray) {
                this.context.setState(State.ArrayValue);
            } else if (this.context.getState() == State.ArrayValue) {
                // empty if block
            }
        }
    }

    public static class Context {
        private final Context parent;
        private State state;

        public Context(Context parent, State state) {
            this.parent = parent;
            this.state = state;
        }

        public Context getParent() {
            return this.parent;
        }

        public State getState() {
            return this.state;
        }

        public void setState(State state) {
            this.state = state;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        BeginObject,
        PropertyKey,
        PropertyValue,
        BeginArray,
        ArrayValue;

    }
}

