/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

public final class BitArray {
    private int[] bits;
    private int size;

    public BitArray() {
        this.size = 0;
        this.bits = new int[1];
    }

    public BitArray(int size) {
        this.size = size;
        this.bits = BitArray.makeArray(size);
    }

    public int getSize() {
        return this.size;
    }

    public int getSizeInBytes() {
        return this.size + 7 >> 3;
    }

    private void ensureCapacity(int size) {
        if (size > this.bits.length << 5) {
            int[] newBits = BitArray.makeArray(size);
            System.arraycopy(this.bits, 0, newBits, 0, this.bits.length);
            this.bits = newBits;
        }
    }

    public boolean get(int i) {
        return (this.bits[i >> 5] & 1 << (i & 0x1F)) != 0;
    }

    public void set(int i) {
        int n = i >> 5;
        this.bits[n] = this.bits[n] | 1 << (i & 0x1F);
    }

    public void flip(int i) {
        int n = i >> 5;
        this.bits[n] = this.bits[n] ^ 1 << (i & 0x1F);
    }

    public int getNextSet(int from) {
        if (from >= this.size) {
            return this.size;
        }
        int bitsOffset = from >> 5;
        int currentBits = this.bits[bitsOffset];
        currentBits &= ~((1 << (from & 0x1F)) - 1);
        while (currentBits == 0) {
            if (++bitsOffset == this.bits.length) {
                return this.size;
            }
            currentBits = this.bits[bitsOffset];
        }
        int result = (bitsOffset << 5) + Integer.numberOfTrailingZeros(currentBits);
        return result > this.size ? this.size : result;
    }

    public int getNextUnset(int from) {
        if (from >= this.size) {
            return this.size;
        }
        int bitsOffset = from >> 5;
        int currentBits = ~this.bits[bitsOffset];
        currentBits &= ~((1 << (from & 0x1F)) - 1);
        while (currentBits == 0) {
            if (++bitsOffset == this.bits.length) {
                return this.size;
            }
            currentBits = ~this.bits[bitsOffset];
        }
        int result = (bitsOffset << 5) + Integer.numberOfTrailingZeros(currentBits);
        return result > this.size ? this.size : result;
    }

    public void setBulk(int i, int newBits) {
        this.bits[i >> 5] = newBits;
    }

    public void setRange(int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        if (end == start) {
            return;
        }
        int firstInt = start >> 5;
        int lastInt = --end >> 5;
        int i = firstInt;
        while (i <= lastInt) {
            int mask;
            int lastBit;
            int firstBit = i > firstInt ? 0 : start & 0x1F;
            int n = lastBit = i < lastInt ? 31 : end & 0x1F;
            if (firstBit == 0 && lastBit == 31) {
                mask = -1;
            } else {
                mask = 0;
                int j = firstBit;
                while (j <= lastBit) {
                    mask |= 1 << j;
                    ++j;
                }
            }
            int n2 = i++;
            this.bits[n2] = this.bits[n2] | mask;
        }
    }

    public void clear() {
        int max = this.bits.length;
        int i = 0;
        while (i < max) {
            this.bits[i] = 0;
            ++i;
        }
    }

    public boolean isRange(int start, int end, boolean value) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        if (end == start) {
            return true;
        }
        int firstInt = start >> 5;
        int lastInt = --end >> 5;
        int i = firstInt;
        while (i <= lastInt) {
            int mask;
            int lastBit;
            int firstBit = i > firstInt ? 0 : start & 0x1F;
            int n = lastBit = i < lastInt ? 31 : end & 0x1F;
            if (firstBit == 0 && lastBit == 31) {
                mask = -1;
            } else {
                mask = 0;
                int j = firstBit;
                while (j <= lastBit) {
                    mask |= 1 << j;
                    ++j;
                }
            }
            if ((this.bits[i] & mask) != (value ? mask : 0)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void appendBit(boolean bit) {
        this.ensureCapacity(this.size + 1);
        if (bit) {
            int n = this.size >> 5;
            this.bits[n] = this.bits[n] | 1 << (this.size & 0x1F);
        }
        ++this.size;
    }

    public void appendBits(int value, int numBits) {
        if (numBits < 0 || numBits > 32) {
            throw new IllegalArgumentException("Num bits must be between 0 and 32");
        }
        this.ensureCapacity(this.size + numBits);
        int numBitsLeft = numBits;
        while (numBitsLeft > 0) {
            this.appendBit((value >> numBitsLeft - 1 & 1) == 1);
            --numBitsLeft;
        }
    }

    public void appendBitArray(BitArray other) {
        int otherSize = other.size;
        this.ensureCapacity(this.size + otherSize);
        int i = 0;
        while (i < otherSize) {
            this.appendBit(other.get(i));
            ++i;
        }
    }

    public void xor(BitArray other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Sizes don't match");
        }
        int i = 0;
        while (i < this.bits.length) {
            int n = i;
            this.bits[n] = this.bits[n] ^ other.bits[i];
            ++i;
        }
    }

    public void toBytes(int bitOffset, byte[] array, int offset, int numBytes) {
        int i = 0;
        while (i < numBytes) {
            int theByte = 0;
            int j = 0;
            while (j < 8) {
                if (this.get(bitOffset)) {
                    theByte |= 1 << 7 - j;
                }
                ++bitOffset;
                ++j;
            }
            array[offset + i] = (byte)theByte;
            ++i;
        }
    }

    public int[] getBitArray() {
        return this.bits;
    }

    public void reverse() {
        int[] newBits = new int[this.bits.length];
        int size = this.size;
        int i = 0;
        while (i < size) {
            if (this.get(size - i - 1)) {
                int n = i >> 5;
                newBits[n] = newBits[n] | 1 << (i & 0x1F);
            }
            ++i;
        }
        this.bits = newBits;
    }

    private static int[] makeArray(int size) {
        return new int[size + 31 >> 5];
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.size);
        int i = 0;
        while (i < this.size) {
            if ((i & 7) == 0) {
                result.append(' ');
            }
            result.append(this.get(i) ? (char)'X' : '.');
            ++i;
        }
        return result.toString();
    }
}

