/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.oned.CodaBarReader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Arrays;

public final class CodaBarWriter
extends OneDimensionalCodeWriter {
    private static final char[] START_CHARS = new char[]{'A', 'B', 'C', 'D'};
    private static final char[] END_CHARS = new char[]{'T', 'N', '*', 'E'};

    @Override
    public boolean[] encode(String contents) {
        if (!CodaBarReader.arrayContains(START_CHARS, Character.toUpperCase(contents.charAt(0)))) {
            throw new IllegalArgumentException("Codabar should start with one of the following: " + Arrays.toString(START_CHARS));
        }
        if (!CodaBarReader.arrayContains(END_CHARS, Character.toUpperCase(contents.charAt(contents.length() - 1)))) {
            throw new IllegalArgumentException("Codabar should end with one of the following: " + Arrays.toString(END_CHARS));
        }
        int resultLength = 20;
        char[] charsWhichAreTenLengthEachAfterDecoded = new char[]{'/', ':', '+', '.'};
        int i = 1;
        while (i < contents.length() - 1) {
            if (Character.isDigit(contents.charAt(i)) || contents.charAt(i) == '-' || contents.charAt(i) == '$') {
                resultLength += 9;
            } else if (CodaBarReader.arrayContains(charsWhichAreTenLengthEachAfterDecoded, contents.charAt(i))) {
                resultLength += 10;
            } else {
                throw new IllegalArgumentException("Cannot encode : '" + contents.charAt(i) + '\'');
            }
            ++i;
        }
        boolean[] result = new boolean[resultLength += contents.length() - 1];
        int position = 0;
        int index = 0;
        while (index < contents.length()) {
            char c = Character.toUpperCase(contents.charAt(index));
            if (index == contents.length() - 1) {
                switch (c) {
                    case 'T': {
                        c = 'A';
                        break;
                    }
                    case 'N': {
                        c = 'B';
                        break;
                    }
                    case '*': {
                        c = 'C';
                        break;
                    }
                    case 'E': {
                        c = 'D';
                    }
                }
            }
            int code = 0;
            int i2 = 0;
            while (i2 < CodaBarReader.ALPHABET.length) {
                if (c == CodaBarReader.ALPHABET[i2]) {
                    code = CodaBarReader.CHARACTER_ENCODINGS[i2];
                    break;
                }
                ++i2;
            }
            boolean color = true;
            int counter = 0;
            int bit = 0;
            while (bit < 7) {
                result[position] = color;
                ++position;
                if ((code >> 6 - bit & 1) == 0 || counter == 1) {
                    color = !color;
                    ++bit;
                    counter = 0;
                    continue;
                }
                ++counter;
            }
            if (index < contents.length() - 1) {
                result[position] = false;
                ++position;
            }
            ++index;
        }
        return result;
    }
}

