/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.messaging;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.stomp.BufferingStompDecoder;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompConversionException;
import org.springframework.messaging.simp.stomp.StompEncoder;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.simp.user.DestinationUserNameProvider;
import org.springframework.messaging.simp.user.UserSessionRegistry;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.SessionLimitExceededException;
import org.springframework.web.socket.handler.WebSocketSessionDecorator;
import org.springframework.web.socket.messaging.SessionConnectEvent;
import org.springframework.web.socket.messaging.SessionConnectedEvent;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;
import org.springframework.web.socket.messaging.SubProtocolHandler;
import org.springframework.web.socket.sockjs.transport.SockJsSession;

public class StompSubProtocolHandler
implements SubProtocolHandler,
ApplicationEventPublisherAware {
    public static final int MINIMUM_WEBSOCKET_MESSAGE_SIZE = 16640;
    public static final String CONNECTED_USER_HEADER = "user-name";
    private static final Log logger = LogFactory.getLog(StompSubProtocolHandler.class);
    private int messageSizeLimit = 65536;
    private final Map<String, BufferingStompDecoder> decoders = new ConcurrentHashMap<String, BufferingStompDecoder>();
    private final StompEncoder stompEncoder = new StompEncoder();
    private UserSessionRegistry userSessionRegistry;
    private ApplicationEventPublisher eventPublisher;

    public void setMessageSizeLimit(int messageSizeLimit) {
        this.messageSizeLimit = messageSizeLimit;
    }

    public int getMessageSizeLimit() {
        return this.messageSizeLimit;
    }

    public void setUserSessionRegistry(UserSessionRegistry registry) {
        this.userSessionRegistry = registry;
    }

    public UserSessionRegistry getUserSessionRegistry() {
        return this.userSessionRegistry;
    }

    @Override
    public List<String> getSupportedProtocols() {
        return Arrays.asList("v10.stomp", "v11.stomp", "v12.stomp");
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    @Override
    public void handleMessageFromClient(WebSocketSession session, WebSocketMessage<?> webSocketMessage, MessageChannel outputChannel) {
        List messages = null;
        try {
            Assert.isInstanceOf(TextMessage.class, webSocketMessage);
            TextMessage textMessage = (TextMessage)webSocketMessage;
            ByteBuffer byteBuffer = ByteBuffer.wrap(textMessage.asBytes());
            BufferingStompDecoder decoder = this.decoders.get(session.getId());
            if (decoder == null) {
                throw new IllegalStateException("No decoder for session id '" + session.getId() + "'");
            }
            messages = decoder.decode(byteBuffer);
            if (messages.isEmpty()) {
                logger.debug((Object)("Incomplete STOMP frame content received,buffered=" + decoder.getBufferSize() + ", buffer size limit=" + decoder.getBufferSizeLimit()));
                return;
            }
        }
        catch (Throwable ex) {
            logger.error((Object)"Failed to parse WebSocket message to STOMP frame(s)", ex);
            this.sendErrorMessage(session, ex);
            return;
        }
        for (Message message : messages) {
            try {
                StompHeaderAccessor headers = StompHeaderAccessor.wrap((Message)message);
                if (logger.isTraceEnabled()) {
                    if (SimpMessageType.HEARTBEAT.equals((Object)headers.getMessageType())) {
                        logger.trace((Object)("Received heartbeat from client session=" + session.getId()));
                    } else {
                        logger.trace((Object)("Received message from client session=" + session.getId()));
                    }
                }
                headers.setSessionId(session.getId());
                headers.setSessionAttributes(session.getAttributes());
                headers.setUser(session.getPrincipal());
                message = MessageBuilder.withPayload((Object)message.getPayload()).setHeaders((MessageHeaderAccessor)headers).build();
                if (this.eventPublisher != null && StompCommand.CONNECT.equals((Object)headers.getCommand())) {
                    this.publishEvent(new SessionConnectEvent(this, (Message<byte[]>)message));
                }
                outputChannel.send(message);
            }
            catch (Throwable ex) {
                logger.error((Object)"Terminating STOMP session due to failure to send message", ex);
                this.sendErrorMessage(session, ex);
            }
        }
    }

    private void publishEvent(ApplicationEvent event) {
        try {
            this.eventPublisher.publishEvent(event);
        }
        catch (Throwable ex) {
            logger.error((Object)("Error while publishing " + event), ex);
        }
    }

    protected void sendErrorMessage(WebSocketSession session, Throwable error) {
        StompHeaderAccessor headers = StompHeaderAccessor.create((StompCommand)StompCommand.ERROR);
        headers.setMessage(error.getMessage());
        Message message = MessageBuilder.withPayload((Object)new byte[0]).setHeaders((MessageHeaderAccessor)headers).build();
        byte[] bytes = this.stompEncoder.encode(message);
        try {
            session.sendMessage(new TextMessage(bytes));
        }
        catch (Throwable ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessageToClient(WebSocketSession session, Message<?> message) {
        StompHeaderAccessor headers = StompHeaderAccessor.wrap(message);
        if (headers.getMessageType() == SimpMessageType.CONNECT_ACK) {
            StompHeaderAccessor connectedHeaders = StompHeaderAccessor.create((StompCommand)StompCommand.CONNECTED);
            connectedHeaders.setVersion(this.getVersion(headers));
            connectedHeaders.setHeartbeat(0L, 0L);
            headers = connectedHeaders;
        } else if (SimpMessageType.MESSAGE.equals((Object)headers.getMessageType())) {
            headers.updateStompCommandAsServerMessage();
        }
        if (headers.getCommand() == StompCommand.CONNECTED) {
            this.afterStompSessionConnected(headers, session);
        }
        if (StompCommand.MESSAGE.equals((Object)headers.getCommand())) {
            if (headers.getSubscriptionId() == null) {
                logger.error((Object)("Ignoring message, no subscriptionId header: " + message));
                return;
            }
            String name = "subscribeDestination";
            String origDestination = headers.getFirstNativeHeader(name);
            if (origDestination != null) {
                headers.setDestination(origDestination);
            }
        }
        if (!(message.getPayload() instanceof byte[])) {
            logger.error((Object)("Ignoring message, expected byte[] content: " + message));
            return;
        }
        try {
            message = MessageBuilder.withPayload((Object)message.getPayload()).setHeaders((MessageHeaderAccessor)headers).build();
            if (this.eventPublisher != null && StompCommand.CONNECTED.equals((Object)headers.getCommand())) {
                this.publishEvent(new SessionConnectedEvent(this, (Message<byte[]>)message));
            }
            byte[] bytes = this.stompEncoder.encode(message);
            TextMessage textMessage = new TextMessage(bytes);
            session.sendMessage(textMessage);
        }
        catch (SessionLimitExceededException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            this.sendErrorMessage(session, ex);
        }
        finally {
            if (StompCommand.ERROR.equals((Object)headers.getCommand())) {
                try {
                    session.close(CloseStatus.PROTOCOL_ERROR);
                }
                catch (IOException ex) {}
            }
        }
    }

    private String getVersion(StompHeaderAccessor connectAckHeaders) {
        String name = "simpConnectMessage";
        Message connectMessage = (Message)connectAckHeaders.getHeader(name);
        StompHeaderAccessor connectHeaders = StompHeaderAccessor.wrap((Message)connectMessage);
        Assert.notNull((Object)connectMessage, (String)("CONNECT_ACK does not contain original CONNECT " + connectAckHeaders));
        Set acceptVersions = connectHeaders.getAcceptVersion();
        if (acceptVersions.contains("1.2")) {
            return "1.2";
        }
        if (acceptVersions.contains("1.1")) {
            return "1.1";
        }
        if (acceptVersions.isEmpty()) {
            return null;
        }
        throw new StompConversionException("Unsupported version '" + acceptVersions + "'");
    }

    private void afterStompSessionConnected(StompHeaderAccessor headers, WebSocketSession session) {
        long[] heartbeat;
        Principal principal = session.getPrincipal();
        if (principal != null) {
            headers.setNativeHeader(CONNECTED_USER_HEADER, principal.getName());
            if (this.userSessionRegistry != null) {
                String userName = this.resolveNameForUserSessionRegistry(principal);
                this.userSessionRegistry.registerSessionId(userName, session.getId());
            }
        }
        if ((heartbeat = headers.getHeartbeat())[1] > 0L && (session = WebSocketSessionDecorator.unwrap(session)) instanceof SockJsSession) {
            logger.debug((Object)"STOMP heartbeats negotiated, disabling SockJS heartbeats.");
            ((SockJsSession)session).disableHeartbeat();
        }
    }

    private String resolveNameForUserSessionRegistry(Principal principal) {
        String userName = principal.getName();
        if (principal instanceof DestinationUserNameProvider) {
            userName = ((DestinationUserNameProvider)principal).getDestinationUserName();
        }
        return userName;
    }

    @Override
    public String resolveSessionId(Message<?> message) {
        StompHeaderAccessor headers = StompHeaderAccessor.wrap(message);
        return headers.getSessionId();
    }

    @Override
    public void afterSessionStarted(WebSocketSession session, MessageChannel outputChannel) {
        if (session.getTextMessageSizeLimit() < 16640) {
            session.setTextMessageSizeLimit(16640);
        }
        this.decoders.put(session.getId(), new BufferingStompDecoder(this.getMessageSizeLimit()));
    }

    @Override
    public void afterSessionEnded(WebSocketSession session, CloseStatus closeStatus, MessageChannel outputChannel) {
        this.decoders.remove(session.getId());
        Principal principal = session.getPrincipal();
        if (this.userSessionRegistry != null && principal != null) {
            String userName = this.resolveNameForUserSessionRegistry(principal);
            this.userSessionRegistry.unregisterSessionId(userName, session.getId());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"WebSocket session ended, sending DISCONNECT message to broker");
        }
        StompHeaderAccessor headers = StompHeaderAccessor.create((StompCommand)StompCommand.DISCONNECT);
        headers.setSessionId(session.getId());
        Message message = MessageBuilder.withPayload((Object)new byte[0]).setHeaders((MessageHeaderAccessor)headers).build();
        if (this.eventPublisher != null) {
            this.publishEvent(new SessionDisconnectEvent(this, session.getId(), closeStatus));
        }
        outputChannel.send(message);
    }
}

