/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.FormatException;
import java.util.HashMap;
import java.util.Map;

public final class CharacterSetECI
extends Enum<CharacterSetECI> {
    public static final /* enum */ CharacterSetECI Cp437;
    public static final /* enum */ CharacterSetECI ISO8859_1;
    public static final /* enum */ CharacterSetECI ISO8859_2;
    public static final /* enum */ CharacterSetECI ISO8859_3;
    public static final /* enum */ CharacterSetECI ISO8859_4;
    public static final /* enum */ CharacterSetECI ISO8859_5;
    public static final /* enum */ CharacterSetECI ISO8859_6;
    public static final /* enum */ CharacterSetECI ISO8859_7;
    public static final /* enum */ CharacterSetECI ISO8859_8;
    public static final /* enum */ CharacterSetECI ISO8859_9;
    public static final /* enum */ CharacterSetECI ISO8859_10;
    public static final /* enum */ CharacterSetECI ISO8859_11;
    public static final /* enum */ CharacterSetECI ISO8859_13;
    public static final /* enum */ CharacterSetECI ISO8859_14;
    public static final /* enum */ CharacterSetECI ISO8859_15;
    public static final /* enum */ CharacterSetECI ISO8859_16;
    public static final /* enum */ CharacterSetECI SJIS;
    public static final /* enum */ CharacterSetECI Cp1250;
    public static final /* enum */ CharacterSetECI Cp1251;
    public static final /* enum */ CharacterSetECI Cp1252;
    public static final /* enum */ CharacterSetECI Cp1256;
    public static final /* enum */ CharacterSetECI UnicodeBigUnmarked;
    public static final /* enum */ CharacterSetECI UTF8;
    public static final /* enum */ CharacterSetECI ASCII;
    public static final /* enum */ CharacterSetECI Big5;
    public static final /* enum */ CharacterSetECI GB18030;
    public static final /* enum */ CharacterSetECI EUC_KR;
    private static final Map<Integer, CharacterSetECI> VALUE_TO_ECI;
    private static final Map<String, CharacterSetECI> NAME_TO_ECI;
    private final int[] values;
    private final String[] otherEncodingNames;
    private static final /* synthetic */ CharacterSetECI[] ENUM$VALUES;

    static {
        int[] nArray = new int[2];
        nArray[1] = 2;
        Cp437 = new CharacterSetECI(nArray, new String[0]);
        ISO8859_1 = new CharacterSetECI(new int[]{1, 3}, "ISO-8859-1");
        ISO8859_2 = new CharacterSetECI(4, "ISO-8859-2");
        ISO8859_3 = new CharacterSetECI(5, "ISO-8859-3");
        ISO8859_4 = new CharacterSetECI(6, "ISO-8859-4");
        ISO8859_5 = new CharacterSetECI(7, "ISO-8859-5");
        ISO8859_6 = new CharacterSetECI(8, "ISO-8859-6");
        ISO8859_7 = new CharacterSetECI(9, "ISO-8859-7");
        ISO8859_8 = new CharacterSetECI(10, "ISO-8859-8");
        ISO8859_9 = new CharacterSetECI(11, "ISO-8859-9");
        ISO8859_10 = new CharacterSetECI(12, "ISO-8859-10");
        ISO8859_11 = new CharacterSetECI(13, "ISO-8859-11");
        ISO8859_13 = new CharacterSetECI(15, "ISO-8859-13");
        ISO8859_14 = new CharacterSetECI(16, "ISO-8859-14");
        ISO8859_15 = new CharacterSetECI(17, "ISO-8859-15");
        ISO8859_16 = new CharacterSetECI(18, "ISO-8859-16");
        SJIS = new CharacterSetECI(20, "Shift_JIS");
        Cp1250 = new CharacterSetECI(21, "windows-1250");
        Cp1251 = new CharacterSetECI(22, "windows-1251");
        Cp1252 = new CharacterSetECI(23, "windows-1252");
        Cp1256 = new CharacterSetECI(24, "windows-1256");
        UnicodeBigUnmarked = new CharacterSetECI(25, "UTF-16BE", "UnicodeBig");
        UTF8 = new CharacterSetECI(26, "UTF-8");
        ASCII = new CharacterSetECI(new int[]{27, 170}, "US-ASCII");
        Big5 = new CharacterSetECI(28);
        GB18030 = new CharacterSetECI(29, "GB2312", "EUC_CN", "GBK");
        EUC_KR = new CharacterSetECI(30, "EUC-KR");
        ENUM$VALUES = new CharacterSetECI[]{Cp437, ISO8859_1, ISO8859_2, ISO8859_3, ISO8859_4, ISO8859_5, ISO8859_6, ISO8859_7, ISO8859_8, ISO8859_9, ISO8859_10, ISO8859_11, ISO8859_13, ISO8859_14, ISO8859_15, ISO8859_16, SJIS, Cp1250, Cp1251, Cp1252, Cp1256, UnicodeBigUnmarked, UTF8, ASCII, Big5, GB18030, EUC_KR};
        VALUE_TO_ECI = new HashMap<Integer, CharacterSetECI>();
        NAME_TO_ECI = new HashMap<String, CharacterSetECI>();
        CharacterSetECI[] characterSetECIArray = CharacterSetECI.values();
        int n = characterSetECIArray.length;
        int n2 = 0;
        while (n2 < n) {
            CharacterSetECI eci = characterSetECIArray[n2];
            Object[] objectArray = eci.values;
            int n3 = eci.values.length;
            int n4 = 0;
            while (n4 < n3) {
                int value = objectArray[n4];
                VALUE_TO_ECI.put(value, eci);
                ++n4;
            }
            NAME_TO_ECI.put(eci.name(), eci);
            objectArray = eci.otherEncodingNames;
            n3 = eci.otherEncodingNames.length;
            n4 = 0;
            while (n4 < n3) {
                int name = objectArray[n4];
                NAME_TO_ECI.put((String)name, eci);
                ++n4;
            }
            ++n2;
        }
    }

    private CharacterSetECI(int value) {
        this(new int[]{value}, new String[0]);
    }

    private CharacterSetECI(int value, String ... otherEncodingNames) {
        this.values = new int[]{value};
        this.otherEncodingNames = otherEncodingNames;
    }

    private CharacterSetECI(int[] values, String ... otherEncodingNames) {
        this.values = values;
        this.otherEncodingNames = otherEncodingNames;
    }

    public int getValue() {
        return this.values[0];
    }

    public static CharacterSetECI getCharacterSetECIByValue(int value) throws FormatException {
        if (value < 0 || value >= 900) {
            throw FormatException.getFormatInstance();
        }
        return VALUE_TO_ECI.get(value);
    }

    public static CharacterSetECI getCharacterSetECIByName(String name) {
        return NAME_TO_ECI.get(name);
    }

    public static CharacterSetECI[] values() {
        CharacterSetECI[] characterSetECIArray = ENUM$VALUES;
        int n = characterSetECIArray.length;
        CharacterSetECI[] characterSetECIArray2 = new CharacterSetECI[n];
        System.arraycopy(ENUM$VALUES, 0, characterSetECIArray2, 0, n);
        return characterSetECIArray2;
    }

    public static CharacterSetECI valueOf(String string) {
        return Enum.valueOf(CharacterSetECI.class, string);
    }
}

