/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.util.FieldInfo;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldDeserializer {
    protected final FieldInfo fieldInfo;
    protected final Class<?> clazz;

    public FieldDeserializer(Class<?> clazz, FieldInfo fieldInfo) {
        this.clazz = clazz;
        this.fieldInfo = fieldInfo;
    }

    public Method getMethod() {
        return this.fieldInfo.getMethod();
    }

    public Class<?> getFieldClass() {
        return this.fieldInfo.getFieldClass();
    }

    public Type getFieldType() {
        return this.fieldInfo.getFieldType();
    }

    public abstract void parseField(DefaultJSONParser var1, Object var2, Type var3, Map<String, Object> var4);

    public abstract int getFastMatchToken();

    public void setValue(Object object, boolean value) {
        this.setValue(object, (Object)value);
    }

    public void setValue(Object object, int value) {
        this.setValue(object, (Object)value);
    }

    public void setValue(Object object, long value) {
        this.setValue(object, (Object)value);
    }

    public void setValue(Object object, String value) {
        this.setValue(object, (Object)value);
    }

    public void setValue(Object object, Object value) {
        Method method = this.fieldInfo.getMethod();
        if (method != null) {
            try {
                if (this.fieldInfo.isGetOnly()) {
                    Collection collection = (Collection)method.invoke(object, new Object[0]);
                    collection.addAll((Collection)value);
                }
                method.invoke(object, value);
            }
            catch (Exception e) {
                throw new JSONException("set property error, " + this.fieldInfo.getName(), e);
            }
        } else if (this.fieldInfo.getField() != null) {
            try {
                this.fieldInfo.getField().set(object, value);
            }
            catch (Exception e) {
                throw new JSONException("set property error, " + this.fieldInfo.getName(), e);
            }
        }
    }
}

