/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client;

import java.util.List;
import java.util.Map;
import org.springframework.context.SmartLifecycle;
import org.springframework.http.HttpHeaders;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.ConnectionManagerSupport;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.handler.LoggingWebSocketHandlerDecorator;

public class WebSocketConnectionManager
extends ConnectionManagerSupport {
    private final WebSocketClient client;
    private final WebSocketHandler webSocketHandler;
    private WebSocketSession webSocketSession;
    private WebSocketHttpHeaders headers = new WebSocketHttpHeaders();
    private final boolean syncClientLifecycle;

    public WebSocketConnectionManager(WebSocketClient client, WebSocketHandler webSocketHandler, String uriTemplate, Object ... uriVariables) {
        super(uriTemplate, uriVariables);
        this.client = client;
        this.webSocketHandler = this.decorateWebSocketHandler(webSocketHandler);
        this.syncClientLifecycle = client instanceof SmartLifecycle && !((SmartLifecycle)client).isRunning();
    }

    protected WebSocketHandler decorateWebSocketHandler(WebSocketHandler handler) {
        return new LoggingWebSocketHandlerDecorator(handler);
    }

    public void setSubProtocols(List<String> protocols) {
        this.headers.setSecWebSocketProtocol(protocols);
    }

    public List<String> getSubProtocols() {
        return this.headers.getSecWebSocketProtocol();
    }

    public void setOrigin(String origin) {
        this.headers.setOrigin(origin);
    }

    public String getOrigin() {
        return this.headers.getOrigin();
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers.clear();
        this.headers.putAll((Map<? extends String, ? extends List<String>>)headers);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public void startInternal() {
        if (this.syncClientLifecycle) {
            ((SmartLifecycle)this.client).start();
        }
        super.startInternal();
    }

    @Override
    public void stopInternal() throws Exception {
        if (this.syncClientLifecycle) {
            ((SmartLifecycle)this.client).stop();
        }
        super.stopInternal();
    }

    @Override
    protected void openConnection() {
        this.logger.info((Object)("Connecting to WebSocket at " + this.getUri()));
        ListenableFuture<WebSocketSession> future = this.client.doHandshake(this.webSocketHandler, this.headers, this.getUri());
        future.addCallback((ListenableFutureCallback)new ListenableFutureCallback<WebSocketSession>(){

            public void onSuccess(WebSocketSession result) {
                WebSocketConnectionManager.this.webSocketSession = result;
                WebSocketConnectionManager.this.logger.info((Object)"Successfully connected");
            }

            public void onFailure(Throwable t) {
                WebSocketConnectionManager.this.logger.error((Object)"Failed to connect", t);
            }
        });
    }

    @Override
    protected void closeConnection() throws Exception {
        this.webSocketSession.close();
    }

    @Override
    protected boolean isConnected() {
        return this.webSocketSession != null && this.webSocketSession.isOpen();
    }
}

