/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.adapter;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.PingMessage;
import org.springframework.web.socket.PongMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.adapter.NativeWebSocketSession;

public abstract class AbstractWebSocketSession<T>
implements NativeWebSocketSession {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private T nativeSession;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public AbstractWebSocketSession(Map<String, Object> attributes) {
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public T getNativeSession() {
        return this.nativeSession;
    }

    public <R> R getNativeSession(Class<R> requiredType) {
        if (requiredType != null && requiredType.isInstance(this.nativeSession)) {
            return (R)this.nativeSession;
        }
        return null;
    }

    public void initializeNativeSession(T session) {
        Assert.notNull(session, (String)"session must not be null");
        this.nativeSession = session;
    }

    protected final void checkNativeSessionInitialized() {
        Assert.state((this.nativeSession != null ? 1 : 0) != 0, (String)"WebSocket session is not yet initialized");
    }

    @Override
    public final void sendMessage(WebSocketMessage<?> message) throws IOException {
        this.checkNativeSessionInitialized();
        Assert.isTrue((boolean)this.isOpen(), (String)"Cannot send message after connection closed.");
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Sending " + message + ", " + this));
        }
        if (message instanceof TextMessage) {
            this.sendTextMessage((TextMessage)message);
        } else if (message instanceof BinaryMessage) {
            this.sendBinaryMessage((BinaryMessage)message);
        } else if (message instanceof PingMessage) {
            this.sendPingMessage((PingMessage)message);
        } else if (message instanceof PongMessage) {
            this.sendPongMessage((PongMessage)message);
        } else {
            throw new IllegalStateException("Unexpected WebSocketMessage type: " + message);
        }
    }

    protected abstract void sendTextMessage(TextMessage var1) throws IOException;

    protected abstract void sendBinaryMessage(BinaryMessage var1) throws IOException;

    protected abstract void sendPingMessage(PingMessage var1) throws IOException;

    protected abstract void sendPongMessage(PongMessage var1) throws IOException;

    @Override
    public final void close() throws IOException {
        this.close(CloseStatus.NORMAL);
    }

    @Override
    public final void close(CloseStatus status) throws IOException {
        this.checkNativeSessionInitialized();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Closing " + this));
        }
        this.closeInternal(status);
    }

    protected abstract void closeInternal(CloseStatus var1) throws IOException;

    public String toString() {
        return "WebSocket session id=" + this.getId();
    }
}

