/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.Operation;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class OpMultiply
extends Operator {
    public OpMultiply(int pos, SpelNodeImpl ... operands) {
        super("*", pos, operands);
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        Object operandOne = this.getLeftOperand().getValueInternal(state).getValue();
        Object operandTwo = this.getRightOperand().getValueInternal(state).getValue();
        if (operandOne instanceof Number && operandTwo instanceof Number) {
            Number leftNumber = (Number)operandOne;
            Number rightNumber = (Number)operandTwo;
            if (leftNumber instanceof Double || rightNumber instanceof Double) {
                return new TypedValue(leftNumber.doubleValue() * rightNumber.doubleValue());
            }
            if (leftNumber instanceof Long || rightNumber instanceof Long) {
                return new TypedValue(leftNumber.longValue() * rightNumber.longValue());
            }
            return new TypedValue(leftNumber.intValue() * rightNumber.intValue());
        }
        if (operandOne instanceof String && operandTwo instanceof Integer) {
            int repeats = (Integer)operandTwo;
            StringBuilder result = new StringBuilder();
            int i = 0;
            while (i < repeats) {
                result.append(operandOne);
                ++i;
            }
            return new TypedValue(result.toString());
        }
        return state.operate(Operation.MULTIPLY, operandOne, operandTwo);
    }
}

