/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel;

import org.springframework.expression.ParseException;
import org.springframework.expression.spel.SpelMessage;

public class SpelParseException
extends ParseException {
    private SpelMessage message;
    private Object[] inserts;

    public SpelParseException(String expressionString, int position, SpelMessage message, Object ... inserts) {
        super(expressionString, position, message.formatMessage(position, inserts));
        this.position = position;
        this.message = message;
        this.inserts = inserts;
    }

    public SpelParseException(int position, SpelMessage message, Object ... inserts) {
        super(position, message.formatMessage(position, inserts));
        this.position = position;
        this.message = message;
        this.inserts = inserts;
    }

    public SpelParseException(int position, Throwable cause, SpelMessage message, Object ... inserts) {
        super(position, message.formatMessage(position, inserts), cause);
        this.position = position;
        this.message = message;
        this.inserts = inserts;
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message.formatMessage(this.position, this.inserts);
        }
        return super.getMessage();
    }

    public SpelMessage getMessageCode() {
        return this.message;
    }

    public Object[] getInserts() {
        return this.inserts;
    }
}

