/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.binding;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.session.SqlSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperProxy
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = -6424540398559729838L;
    private SqlSession sqlSession;

    private <T> MapperProxy(SqlSession sqlSession) {
        this.sqlSession = sqlSession;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        Class<?> declaringInterface = this.findDeclaringInterface(proxy, method);
        MapperMethod mapperMethod = new MapperMethod(declaringInterface, method, this.sqlSession);
        Object result = mapperMethod.execute(args);
        if (result == null && method.getReturnType().isPrimitive() && !method.getReturnType().equals(Void.TYPE)) {
            throw new BindingException("Mapper method '" + method.getName() + "' (" + method.getDeclaringClass() + ") attempted to return null from a method with a primitive return type (" + method.getReturnType() + ").");
        }
        return result;
    }

    private Class<?> findDeclaringInterface(Object proxy, Method method) {
        Class<?> declaringInterface = null;
        for (Class<?> iface : proxy.getClass().getInterfaces()) {
            try {
                Method m = iface.getMethod(method.getName(), method.getParameterTypes());
                if (declaringInterface != null) {
                    throw new BindingException("Ambiguous method mapping.  Two mapper interfaces contain the identical method signature for " + method);
                }
                if (m == null) continue;
                declaringInterface = iface;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (declaringInterface == null) {
            throw new BindingException("Could not find interface with the given method " + method);
        }
        return declaringInterface;
    }

    public static <T> T newMapperProxy(Class<T> mapperInterface, SqlSession sqlSession) {
        ClassLoader classLoader = mapperInterface.getClassLoader();
        Class[] interfaces = new Class[]{mapperInterface};
        MapperProxy proxy = new MapperProxy(sqlSession);
        return (T)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)proxy);
    }
}

