/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.util.FieldInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeserializeBeanInfo {
    private final Class<?> clazz;
    private final Type type;
    private Constructor<?> defaultConstructor;
    private Constructor<?> creatorConstructor;
    private Method factoryMethod;
    private final List<FieldInfo> fieldList = new ArrayList<FieldInfo>();

    public DeserializeBeanInfo(Class<?> clazz) {
        this.clazz = clazz;
        this.type = clazz;
    }

    public Constructor<?> getDefaultConstructor() {
        return this.defaultConstructor;
    }

    public void setDefaultConstructor(Constructor<?> defaultConstructor) {
        this.defaultConstructor = defaultConstructor;
    }

    public Constructor<?> getCreatorConstructor() {
        return this.creatorConstructor;
    }

    public void setCreatorConstructor(Constructor<?> createConstructor) {
        this.creatorConstructor = createConstructor;
    }

    public Method getFactoryMethod() {
        return this.factoryMethod;
    }

    public void setFactoryMethod(Method factoryMethod) {
        this.factoryMethod = factoryMethod;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Type getType() {
        return this.type;
    }

    public List<FieldInfo> getFieldList() {
        return this.fieldList;
    }

    public FieldInfo getField(String propertyName) {
        for (FieldInfo item : this.fieldList) {
            if (!item.getName().equals(propertyName)) continue;
            return item;
        }
        return null;
    }

    public boolean add(FieldInfo field) {
        for (FieldInfo item : this.fieldList) {
            if (!item.getName().equals(field.getName())) continue;
            return false;
        }
        this.fieldList.add(field);
        return true;
    }

    public static DeserializeBeanInfo computeSetters(Class<?> clazz) {
        return DeserializeBeanInfo.computeSetters(clazz, clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static DeserializeBeanInfo computeSetters(Class<?> clazz, Type type) {
        DeserializeBeanInfo beanInfo = new DeserializeBeanInfo(clazz);
        Constructor<?> defaultConstructor = DeserializeBeanInfo.getDefaultConstructor(clazz);
        if (defaultConstructor != null) {
            defaultConstructor.setAccessible(true);
            beanInfo.setDefaultConstructor(defaultConstructor);
        } else if (defaultConstructor == null && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
            Constructor<?> creatorConstructor = DeserializeBeanInfo.getCreatorConstructor(clazz);
            if (creatorConstructor != null) {
                creatorConstructor.setAccessible(true);
                beanInfo.setCreatorConstructor(creatorConstructor);
                for (int i = 0; i < creatorConstructor.getParameterTypes().length; ++i) {
                    void var7_12;
                    Annotation[] paramAnnotations = creatorConstructor.getParameterAnnotations()[i];
                    Object var7_13 = null;
                    for (Annotation paramAnnotation : paramAnnotations) {
                        if (!(paramAnnotation instanceof JSONField)) continue;
                        JSONField jSONField = (JSONField)paramAnnotation;
                        break;
                    }
                    if (var7_12 == null) {
                        throw new JSONException("illegal json creator");
                    }
                    Class<?> fieldClass = creatorConstructor.getParameterTypes()[i];
                    Type fieldType = creatorConstructor.getGenericParameterTypes()[i];
                    Field field = DeserializeBeanInfo.getField(clazz, var7_12.name());
                    if (field != null) {
                        field.setAccessible(true);
                    }
                    FieldInfo fieldInfo = new FieldInfo(var7_12.name(), clazz, fieldClass, fieldType, null, field);
                    beanInfo.add(fieldInfo);
                }
                return beanInfo;
            }
            Method factoryMethod = DeserializeBeanInfo.getFactoryMethod(clazz);
            if (factoryMethod != null) {
                factoryMethod.setAccessible(true);
                beanInfo.setFactoryMethod(factoryMethod);
                for (int i = 0; i < factoryMethod.getParameterTypes().length; ++i) {
                    Annotation[] annotationArray = factoryMethod.getParameterAnnotations()[i];
                    JSONField fieldAnnotation = null;
                    for (Annotation paramAnnotation : annotationArray) {
                        if (!(paramAnnotation instanceof JSONField)) continue;
                        fieldAnnotation = (JSONField)paramAnnotation;
                        break;
                    }
                    if (fieldAnnotation == null) {
                        throw new JSONException("illegal json creator");
                    }
                    Class<?> fieldClass = factoryMethod.getParameterTypes()[i];
                    Type fieldType = factoryMethod.getGenericParameterTypes()[i];
                    Field field = DeserializeBeanInfo.getField(clazz, fieldAnnotation.name());
                    if (field != null) {
                        field.setAccessible(true);
                    }
                    FieldInfo fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, fieldClass, fieldType, null, field);
                    beanInfo.add(fieldInfo);
                }
                return beanInfo;
            }
            throw new JSONException("default constructor not found. " + clazz);
        }
        for (Method method : clazz.getMethods()) {
            JSONField fieldAnnotation;
            String propertyName;
            String methodName = method.getName();
            if (methodName.length() < 4 || Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(Void.TYPE) && !method.getReturnType().equals(clazz) || method.getParameterTypes().length != 1) continue;
            JSONField annotation = method.getAnnotation(JSONField.class);
            if (annotation != null) {
                if (!annotation.deserialize()) continue;
                if (annotation.name().length() != 0) {
                    propertyName = annotation.name();
                    beanInfo.add(new FieldInfo(propertyName, method, null, clazz, type));
                    method.setAccessible(true);
                    continue;
                }
            }
            if (!methodName.startsWith("set") || !Character.isUpperCase(methodName.charAt(3))) continue;
            propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            Field field = DeserializeBeanInfo.getField(clazz, propertyName);
            if (field != null && (fieldAnnotation = field.getAnnotation(JSONField.class)) != null && fieldAnnotation.name().length() != 0) {
                propertyName = fieldAnnotation.name();
                beanInfo.add(new FieldInfo(propertyName, method, field, clazz, type));
                continue;
            }
            beanInfo.add(new FieldInfo(propertyName, method, null, clazz, type));
            method.setAccessible(true);
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers()) || !Modifier.isPublic(((Field)accessibleObject).getModifiers())) continue;
            boolean contains = false;
            for (FieldInfo item : beanInfo.getFieldList()) {
                if (!item.getName().equals(((Field)accessibleObject).getName())) continue;
                contains = true;
            }
            if (contains) continue;
            beanInfo.add(new FieldInfo(((Field)accessibleObject).getName(), null, (Field)accessibleObject));
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            String propertyName;
            FieldInfo fieldInfo;
            String methodName = ((Method)accessibleObject).getName();
            if (methodName.length() < 4 || Modifier.isStatic(((Method)accessibleObject).getModifiers()) || !methodName.startsWith("get") || !Character.isUpperCase(methodName.charAt(3)) || ((Method)accessibleObject).getParameterTypes().length != 0 || !Collection.class.isAssignableFrom(((Method)accessibleObject).getReturnType()) || (fieldInfo = beanInfo.getField(propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4))) != null) continue;
            beanInfo.add(new FieldInfo(propertyName, (Method)accessibleObject, null, clazz, type));
            ((Method)accessibleObject).setAccessible(true);
        }
        return beanInfo;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Constructor<?> getDefaultConstructor(Class<?> clazz) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return null;
        }
        Constructor<?> defaultConstructor = null;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            defaultConstructor = constructor;
            break;
        }
        if (defaultConstructor == null && clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].equals(clazz.getDeclaringClass())) continue;
                defaultConstructor = constructor;
                break;
            }
        }
        return defaultConstructor;
    }

    public static Constructor<?> getCreatorConstructor(Class<?> clazz) {
        Constructor<?> creatorConstructor = null;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            JSONCreator annotation = constructor.getAnnotation(JSONCreator.class);
            if (annotation == null) continue;
            if (creatorConstructor != null) {
                throw new JSONException("multi-json creator");
            }
            creatorConstructor = constructor;
            break;
        }
        return creatorConstructor;
    }

    public static Method getFactoryMethod(Class<?> clazz) {
        Method factoryMethod = null;
        for (Method method : clazz.getDeclaredMethods()) {
            JSONCreator annotation;
            if (!Modifier.isStatic(method.getModifiers()) || !clazz.isAssignableFrom(method.getReturnType()) || (annotation = method.getAnnotation(JSONCreator.class)) == null) continue;
            if (factoryMethod != null) {
                throw new JSONException("multi-json creator");
            }
            factoryMethod = method;
            break;
        }
        return factoryMethod;
    }
}

