/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.sockjs.SockJsService;
import org.springframework.web.socket.sockjs.transport.TransportHandler;
import org.springframework.web.socket.sockjs.transport.TransportHandlingSockJsService;
import org.springframework.web.socket.sockjs.transport.handler.DefaultSockJsService;

public class SockJsServiceRegistration {
    private TaskScheduler taskScheduler;
    private String clientLibraryUrl;
    private Integer streamBytesLimit;
    private Boolean sessionCookieNeeded;
    private Long heartbeatTime;
    private Long disconnectDelay;
    private Integer httpMessageCacheSize;
    private Boolean webSocketEnabled;
    private final List<TransportHandler> transportHandlers = new ArrayList<TransportHandler>();
    private final List<TransportHandler> transportHandlerOverrides = new ArrayList<TransportHandler>();
    private final List<HandshakeInterceptor> interceptors = new ArrayList<HandshakeInterceptor>();

    public SockJsServiceRegistration(TaskScheduler defaultTaskScheduler) {
        this.taskScheduler = defaultTaskScheduler;
    }

    public SockJsServiceRegistration setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
        return this;
    }

    public SockJsServiceRegistration setClientLibraryUrl(String clientLibraryUrl) {
        this.clientLibraryUrl = clientLibraryUrl;
        return this;
    }

    public SockJsServiceRegistration setStreamBytesLimit(int streamBytesLimit) {
        this.streamBytesLimit = streamBytesLimit;
        return this;
    }

    public SockJsServiceRegistration setSessionCookieNeeded(boolean sessionCookieNeeded) {
        this.sessionCookieNeeded = sessionCookieNeeded;
        return this;
    }

    public SockJsServiceRegistration setHeartbeatTime(long heartbeatTime) {
        this.heartbeatTime = heartbeatTime;
        return this;
    }

    public SockJsServiceRegistration setDisconnectDelay(long disconnectDelay) {
        this.disconnectDelay = disconnectDelay;
        return this;
    }

    public SockJsServiceRegistration setHttpMessageCacheSize(int httpMessageCacheSize) {
        this.httpMessageCacheSize = httpMessageCacheSize;
        return this;
    }

    public SockJsServiceRegistration setWebSocketEnabled(boolean webSocketEnabled) {
        this.webSocketEnabled = webSocketEnabled;
        return this;
    }

    public SockJsServiceRegistration setTransportHandlers(TransportHandler ... handlers) {
        this.transportHandlers.clear();
        if (!ObjectUtils.isEmpty((Object[])handlers)) {
            this.transportHandlers.addAll(Arrays.asList(handlers));
        }
        return this;
    }

    public SockJsServiceRegistration setTransportHandlerOverrides(TransportHandler ... handlers) {
        this.transportHandlerOverrides.clear();
        if (!ObjectUtils.isEmpty((Object[])handlers)) {
            this.transportHandlerOverrides.addAll(Arrays.asList(handlers));
        }
        return this;
    }

    public SockJsServiceRegistration setInterceptors(HandshakeInterceptor ... interceptors) {
        if (!ObjectUtils.isEmpty((Object[])interceptors)) {
            this.interceptors.addAll(Arrays.asList(interceptors));
        }
        return this;
    }

    protected SockJsService getSockJsService() {
        TransportHandlingSockJsService service = this.createSockJsService();
        service.setHandshakeInterceptors(this.interceptors);
        if (this.clientLibraryUrl != null) {
            service.setSockJsClientLibraryUrl(this.clientLibraryUrl);
        }
        if (this.streamBytesLimit != null) {
            service.setStreamBytesLimit(this.streamBytesLimit);
        }
        if (this.sessionCookieNeeded != null) {
            service.setSessionCookieNeeded(this.sessionCookieNeeded);
        }
        if (this.heartbeatTime != null) {
            service.setHeartbeatTime(this.heartbeatTime);
        }
        if (this.disconnectDelay != null) {
            service.setDisconnectDelay(this.disconnectDelay);
        }
        if (this.httpMessageCacheSize != null) {
            service.setHttpMessageCacheSize(this.httpMessageCacheSize);
        }
        if (this.webSocketEnabled != null) {
            service.setWebSocketEnabled(this.webSocketEnabled);
        }
        return service;
    }

    private TransportHandlingSockJsService createSockJsService() {
        if (!this.transportHandlers.isEmpty()) {
            Assert.state((boolean)this.transportHandlerOverrides.isEmpty(), (String)"Specify either TransportHandlers or TransportHandler overrides, not both");
            return new TransportHandlingSockJsService(this.taskScheduler, this.transportHandlers);
        }
        return new DefaultSockJsService(this.taskScheduler, this.transportHandlerOverrides);
    }
}

